<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="utf-8">
    <title>Oxivea</title>
    <meta content="width=device-width, initial-scale=1.0" name="oxivea">
    <meta content="Oxivea" name="keywords">
    <meta content="Oxivea" name="description">

    <!-- Favicon -->
    <link href="logo.jpg" rel="icon" type="image/x-icon">

    <!-- Google Web Fonts -->
    <link rel="preconnect" href="https://fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat&family=Roboto:wght@500;700&display=swap" rel="stylesheet"> 

    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css" rel="stylesheet">

    <!-- Libraries Stylesheet -->
    <link href="lib/owlcarousel/assets/owl.carousel.min.css" rel="stylesheet">
    <link href="lib/lightbox/css/lightbox.min.css" rel="stylesheet">

    <!-- Customized Bootstrap Stylesheet -->
    <link href="css/style.css" rel="stylesheet">
    <style type="text/css">
    body,td,th {
    font-family: Montserrat, sans-serif;
}
    </style>
</head>

<body data-spy="scroll" data-target=".navbar" data-offset="51">
    <!-- Navbar Start -->
    <nav class="navbar fixed-top shadow-sm navbar-expand-lg bg-dark navbar-dark py-1 py-lg-0 px-lg-5">
        <a href="index.php" class="navbar-brand d-block d-lg-none">
            <h1 class="display-4 text-white text-uppercase m-0">OXIVEA</h1>
        </a>
        <button type="button" class="navbar-toggler" data-toggle="collapse" data-target="#navbarCollapse">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse justify-content-between" id="navbarCollapse">
            <div class="navbar-nav ml-auto py-0">
                <a href="#home" class="nav-item nav-link active">Inicio</a>
                <a href="#service" class="nav-item nav-link">Ficha Técnica</a>
                
            </div>
            <a href="index.php" class="navbar-brand bg-primary px-4 mx-3 d-none d-lg-block">
                <h1 class="display-4 text-white text-uppercase m-0">OXIVEA</h1>
            </a>
            <div class="navbar-nav mr-auto py-0">
                <a href="#project" class="nav-item nav-link">Productos</a>
                <a href="#contact" class="nav-item nav-link">Contacto</a>
            </div>
        </div>
    </nav>
    <!-- Navbar End -->


    <!-- Carousel Start -->
    <div class="container-fluid p-0 mb-5 pb-5" id="home">
        <div id="header-carousel" class="carousel slide carousel-fade" data-ride="carousel">
            <div class="carousel-inner">
                <div class="carousel-item position-relative active" style="height: 100vh; min-height: 400px;">
                    <img class="position-absolute w-100 h-100" src="img/carousel-4.jpg" style="object-fit: cover;">
                    <div class="carousel-caption d-flex flex-column align-items-center justify-content-center">
                        <div class="p-3" style="max-width: 900px;">
                            <h4 class="text-white text-uppercase mb-4" style="letter-spacing: 3px;">Oxihierro</h4>
                            <h3 class="display-2 font-secondary text-white mb-4">Colorantes para piso y paredes</h3>
                            <a class="btn btn-light font-weight-bold py-3 px-5 mt-2 btn-scroll" href="#contact">Ventas al mayor aquí</a>
                        </div>
                    </div>
                </div>
                
                <div class="carousel-item position-relative" style="height: 100vh; min-height: 400px;">
                    <img class="position-absolute w-100 h-100" src="img/carousel-1.jpg" style="object-fit: cover;">
                    <div class="carousel-caption d-flex flex-column align-items-center justify-content-center">
                        <div class="p-3" style="max-width: 900px;">
                            <h4 class="text-white text-uppercase mb-4" style="letter-spacing: 3px;">Oxicolor Caucho</h4>
                            <h3 class="display-2 font-secondary text-white mb-4">Colores increibles</h3>
                            <a class="btn btn-light font-weight-bold py-3 px-5 mt-2 btn-scroll" href="#contact">Ventas al mayor aquí</a>
                        </div>
                    </div>
                </div>
                <div class="carousel-item position-relative" style="height: 100vh; min-height: 400px;">
                    <img class="position-absolute w-100 h-100" src="img/carousel-2.jpg" style="object-fit: cover;">
                    <div class="carousel-caption d-flex flex-column align-items-center justify-content-center">
                        <div class="p-3" style="max-width: 900px;">
                            <h4 class="text-white text-uppercase mb-4" style="letter-spacing: 3px;">Oxivea</h4>
                            <h3 class="display-2 font-secondary text-white mb-4">Gran línea de morteros</h3>
                            <a class="btn btn-light font-weight-bold py-3 px-5 mt-2 btn-scroll" href="#contact">Llama a nuestros asesores</a>
                        </div>
                    </div>
                </div>
                <div class="carousel-item position-relative" style="height: 100vh; min-height: 400px;">
                    <img class="position-absolute w-100 h-100" src="img/carousel-3.jpg" style="object-fit: cover;">
                    <div class="carousel-caption d-flex flex-column align-items-center justify-content-center">
                        <div class="p-3" style="max-width: 900px;">
                            <h4 class="text-white text-uppercase mb-4" style="letter-spacing: 3px;">Oxivea</h4>
                            <h3 class="display-2 font-secondary text-white mb-4">La calidad es nuestro norte</h3>
                            <a class="btn btn-light font-weight-bold py-3 px-5 mt-2 btn-scroll" href="#contact">Haz una llamada</a>
                        </div>
                    </div>
                </div>
            </div>
            <a class="carousel-control-prev justify-content-start" href="#header-carousel" data-slide="prev">
                <div class="btn btn-primary px-0" style="width: 68px; height: 68px;">
                    <span class="carousel-control-prev-icon mt-3"></span>
                </div>
            </a>
            <a class="carousel-control-next justify-content-end" href="#header-carousel" data-slide="next">
                <div class="btn btn-primary px-0" style="width: 68px; height: 68px;">
                    <span class="carousel-control-next-icon mt-3"></span>
                </div>
            </a>
        </div>
    </div>
    <!-- Carousel End -->


    <!-- About Start -->
    <div class="container-fluid py-5" id="about">
        <div class="container py-5">
            <div class="row align-items-center">
                <div class="col-lg-5">
                    <img class="img-fluid mb-4 mb-lg-0" src="img/about.jpg" alt="">
                </div>
                <div class="col-lg-7">
                    <h6 class="text-uppercase text-primary mb-3" style="letter-spacing: 3px;">Calidad demostrada</h6>
                    <h1 class="display-4 mb-3"><span class="text-primary">Únicos con certificación</span> ISO 9001<br>otorgada por FONDONORMA</h1>
                    <p>Actualmente en Venezuela somos la única empresa con certificación de gestión de la calidad, norma ISO:9001 otorgada por FONDONORMA. Todos nustros procesos están cuidadosamente enfocadas en la calidad.&nbsp;&nbsp; </p>
                    <a class="btn btn-primary font-weight-bold py-3 px-5 mt-2" type="button" data-toggle="modal" data-target="#exampleModalLong">Leer más</a>
                </div>
            </div>
        </div>
    </div>
    <!-- About End -->


    <!-- Service Start -->
    <div class="container-fluid py-5" id="service">
        <div class="container py-5">
            <div class="section-title position-relative text-center">
              <h6 class="text-uppercase text-primary mb-3" style="letter-spacing: 3px;">Conoce a fondo nuestros productos</h6>
                <h1 class="font-secondary display-4">Ficha Técnica&nbsp;&nbsp;</h1>
            </div>
            <div class="row">
                <div class="col-lg-4 mb-3">
                    <div class="product-item mb-2">
                        <div class="product-img">
                            <img class="img-fluid" src="img/product-1.jpg" alt="">
                            <a type="button" href="venpego" class="btn btn-primary"  data-target="#venpego">
                                <i class="fa fa-2x fa-plus text-white"></i>
                            </a>
                          
                        </div>
                        <div class="bg-secondary text-center p-4">
                       <h3 class="m-0"><a href="venpego">Venpego</a></h3>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 mb-3">
                    <div class="product-item mb-2">
                        <div class="product-img">
                            <img class="img-fluid" src="img/product-2.jpg" alt="">
                            <a type="button"  href="oxicolor" class="btn btn-primary"  data-target="#oxicolor">
                                <i class="fa fa-2x fa-plus text-white"></i>
                            </a>
                        </div>
                        <div class="bg-secondary text-center p-4">
                            <h3 class="m-0"><a href="oxicolor">Oxicolor</a></h3>

                        </div>
                    </div>
                </div>
                <div class="col-lg-4 mb-3">
                    <div class="product-item mb-2">
                        <div class="product-img">
                            <img class="img-fluid" src="img/product-3.jpg" alt="">
                            <a type="button" href="oxihierro" class="btn btn-primary"  data-target="#oxihierro">
                                <i class="fa fa-2x fa-plus text-white"></i>
                            </a>
                        </div>
                        <div class="bg-secondary text-center p-4">
                            <h3 class="m-0"><a href="oxihierro">Oxihierro</a></h3>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 mb-3">
                    <div class="product-item mb-2">
                        <div class="product-img">
                            <img class="img-fluid" src="img/product-4.jpg" alt="">
                            <a type="button" class="btn btn-primary" href="oxiconstruccion" data-target="#oxiconstruccion">
                                <i class="fa fa-2x fa-plus text-white"></i>
                            </a>
                        </div>
                        <div class="bg-secondary text-center p-4">
                            <h3 class="m-0"><a href="oxiconstruccion">Oxiconstrucción</a></h3>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 mb-3">
                    <div class="product-item mb-2">
                        <div class="product-img">
                            <img class="img-fluid" src="img/product-5.jpg" alt="">
                            <a type="button" class="btn btn-primary" href="oxiyeso" data-target="#yeso">
                                <i class="fa fa-2x fa-plus text-white"></i>
                            </a>
                        </div>
                        <div class="bg-secondary text-center p-4">
                            <h3 class="m-0"><a href="oxiyeso">Oxiyeso</a></h3>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 mb-3">
                    <div class="product-item mb-2">
                        <div class="product-img">
                            <img class="img-fluid" src="img/product-6.jpg" alt="">
                            <a type="button" class="btn btn-primary" href="superconcreto" data-target="#supercreto">
                                <i class="fa fa-2x fa-plus text-white"></i>
                            </a>
                        </div>
                        <div class="bg-secondary text-center p-4">
                            <h3 class="m-0"><a href="superconcreto">Supercreto</a></h3>
                        </div>
                  </div>
                </div>
                <div class="col-lg-4 mb-3">
                    <div class="product-item mb-2">
                        <div class="product-img">
                            <img class="img-fluid" src="img/product-7.jpg" alt="">
                            <a type="button" class="btn btn-primary" href="oxicaucho" data-target="#oxicolorcaucho">
                                <i class="fa fa-2x fa-plus text-white"></i>
                            </a>
                        </div>
                        <div class="bg-secondary text-center p-4">
                            <h3 class="m-0"><a href="oxicaucho">Oxicolor Caucho</a></h3>
                        </div>
                  </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Service End -->


    <!-- Gallery Start -->
    <div class="container-fluid bg-gallery" id="project" style="padding: 120px 0; margin: 90px 0;">
        <div class="section-title position-relative text-center" style="margin-bottom: 120px;">
            <h6 class="text-uppercase text-primary mb-3" style="letter-spacing: 3px;">Fotos</h6>
            <h1 class="font-secondary display-4 text-white">Nuestros Productos en la Construcción</h1>
        </div>
        <div class="owl-carousel gallery-carousel">
            <div class="gallery-item">
                <img class="img-fluid w-100" src="img/gallery-1.jpg" alt="">
                <a class="btn btn-primary" href="img/gallery-1.jpg" data-lightbox="gallery">
                    <i class="fa fa-2x fa-plus text-white"></i>
                </a>
            </div>
            <div class="gallery-item">
                <img class="img-fluid w-100" src="img/gallery-2.jpg" alt="">
                <a class="btn btn-primary" href="img/gallery-2.jpg" data-lightbox="gallery">
                    <i class="fa fa-2x fa-plus text-white"></i>
                </a>
            </div>
            <div class="gallery-item">
                <img class="img-fluid w-100" src="img/gallery-3.jpg" alt="">
                <a class="btn btn-primary" href="img/gallery-3.jpg" data-lightbox="gallery">
                    <i class="fa fa-2x fa-plus text-white"></i>
                </a>
            </div>
            <div class="gallery-item">
                <img class="img-fluid w-100" src="img/gallery-4.jpg" alt="">
                <a class="btn btn-primary" href="img/gallery-4.jpg" data-lightbox="gallery">
                    <i class="fa fa-2x fa-plus text-white"></i>
                </a>
            </div>
            <div class="gallery-item">
                <img class="img-fluid w-100" src="img/gallery-5.jpg" alt="">
                <a class="btn btn-primary" href="img/gallery-5.jpg" data-lightbox="gallery">
                    <i class="fa fa-2x fa-plus text-white"></i>
                </a>
            </div>
           
        </div>
    </div>
    <!-- Gallery End -->


    <!-- Team Start -->
    <div class="container-fluid py-5" id="team">
        <div class="container py-5">
            <div class="section-title position-relative text-center">
                <h6 class="text-uppercase text-primary mb-3" style="letter-spacing: 3px;">OXIVEA</h6>
                <h1 class="font-secondary display-4">Empresa líder del mercado venezolano</h1>
            </div>
            <div class="row justify-content-lg-start m-0 mb-4 pb-2 mb-sm-0 pb-sm-0">
                <div class="col-lg-6 p-0">
                    <div class="row m-0">
                        <div class="col-sm-6 p-0 text-center">
                            <div class="h-100 d-flex flex-column justify-content-center bg-secondary p-4">
                                <h5 class="mb-2">Visión, 2028</h5>
                                
                                <p>Dominar el mercado nacional y expandirnos al mercado internacional mediante técnicas, calidad de gestión, procedimientos de trabajo, la fabricación de nuevos productos, con personal altamente calificado, mejorando nuestros equipos de trabajo, automatización de la planta de pego.</p>
                                
                            </div>
                        </div>
                        <div class="col-sm-6 p-0" style="min-height: 300px;">
                            <img class="position-absolute w-100 h-100" src="img/team-1.jpg" style="object-fit: cover;">
                        </div>
                    </div>
                </div>
            </div>
            <div class="row justify-content-lg-end m-0 mb-4 pb-2 mb-sm-0 pb-sm-0">
                <div class="col-lg-6 p-0">
                    <div class="row m-0">
                        <div class="col-sm-6 p-0" style="min-height: 300px;">
                            <img class="position-absolute w-100 h-100" src="img/team-2.jpg" style="object-fit: cover;">
                        </div>
                        <div class="col-sm-6 p-0 text-center">
                            <div class="h-100 d-flex flex-column justify-content-center bg-secondary p-4">
                                <h5 class="mb-2">Propósito</h5>
                                <p>Fabricación, comercialización y distribución de materiales de construcción, que permitan la satisfacción de sus clientes y accionistas.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row justify-content-lg-start m-0 mb-4 pb-2 mb-sm-0 pb-sm-0">
                <div class="col-lg-6 p-0">
                    <div class="row m-0">
                        <div class="col-sm-6 p-0 text-center">
                            <div class="h-100 d-flex flex-column justify-content-center bg-secondary p-4">
                                <h5 class="mb-2">Política de calidad</h5>
                                <p>Oxivea, C.A., es una empresa dedicada a la Fabricación, comercialización y distribución de materiales de construcción (Óxidos y Morteros), es política de la calidad de la empresa, la fabricación de productos de alto desempeño y confiabilidad. Incluyendo el compromiso de cumplir los requisitos aplicables; y la mejora continua del sistema de gestión de la calidad.</p>
                               
                            </div>
                        </div>
                        <div class="col-sm-6 p-0" style="min-height: 300px;">
                            <img class="position-absolute w-100 h-100" src="img/team-3.jpg" style="object-fit: cover;">
                        </div>
                    </div>
                </div>
            </div>
            <
        </div>
    </div>
    <!-- Team End -->


    


    <!-- Testimonial Start -->
    <div class="container-fluid py-5" id="testimonial">
        <div class="container py-5">
            <div class="section-title position-relative text-center" style="margin-bottom: 120px;">
                <h6 class="text-uppercase text-primary mb-3" style="letter-spacing: 3px;">Objetivos</h6>
                <h1 class="display-4">Estamos en la mejora continua</h1>
            </div>
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="owl-carousel testimonial-carousel">
                        <div class="text-center">
                            <img class="img-fluid mx-auto mb-3" src="img/testimonial-1.jpg" style="width: 100px;">
                            <p style="font-size: 22px;">Tenemos la mejor relación entre precio y calidad así como estándares internacionales.</p>
                            <h4>Calidad</h4>
                        </div>
                        <div class="text-center">
                            <img class="img-fluid mx-auto mb-3" src="img/testimonial-2.jpg" style="width: 100px;">
                            <p style="font-size: 22px;">Estamos calificados para ofrecer respuesta oportuna a sus requerimentos.</p>
                            <h4>Respuesta efectiva</h4>
                        </div>
                        <div class="text-center">
                            <img class="img-fluid mx-auto mb-3" src="img/testimonial-3.jpg" style="width: 100px;">
                            <p style="font-size: 22px;">Comuníquese con nuestro equipo de ventas y solicite presupuestos acorde a sus necesidades.</p>
                            <h4>Asesoría técnica</h4>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Testimonial End -->


    <!-- Contact Start -->
    <div class="container-fluid py-5" id="contact">
        <div class="container py-5">
            <div class="section-title position-relative text-center">
                <h6 class="text-uppercase text-primary mb-3" style="letter-spacing: 3px;">Objetivos</h6>
                <h1 class="font-secondary display-4">Contacto rápido</h1>
            </div>
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="contact-form">
                        <div id="success"></div>
                        <form name="sentMessage" id="contactForm" novalidate="novalidate">
                            <div class="form-row">
                                <div class="col-sm-6 control-group">
                                    <input type="text" class="form-control bg-secondary border-0 py-4 px-3" id="name" placeholder="Tu nombre aquí" required="required" data-validation-required-message="Please enter your name" />
                                    <p class="help-block text-danger"></p>
                                </div>
                                <div class="col-sm-6 control-group">
                                    <input type="email" class="form-control bg-secondary border-0 py-4 px-3" id="email" placeholder="Tu dirección de correo" required="required" data-validation-required-message="Please enter your email" />
                                    <p class="help-block text-danger"></p>
                                </div>
                            </div>
                            <div class="control-group">
                                <input type="text" class="form-control bg-secondary border-0 py-4 px-3" id="subject" placeholder="Asunto" required="required" data-validation-required-message="Please enter a subject" />
                                <p class="help-block text-danger"></p>
                            </div>
                            <div class="control-group">
                                <textarea class="form-control bg-secondary border-0 py-2 px-3" rows="6" id="message" placeholder="Mensaje" required="required" data-validation-required-message="Please enter your message"></textarea>
                                <p class="help-block text-danger"></p>
                            </div>
                            <div class="text-center">
                                <button class="btn btn-primary font-weight-bold py-3 px-5" type="submit" id="sendMessageButton">Enviar el mensaje</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
        
        <!-- FAQs Start -->
    <div class="container-fluid py-5" id="faqs">
        <div class="container py-5">
            <div class="section-title position-relative text-center">
                <h6 class="text-uppercase text-primary mb-3" style="letter-spacing: 3px;">ubícanos</h6>
                <h1 class="display-4">Nuestra dirección</h1>
            </div>
            <div class="row">
                <div class="col-md-6 border-right border-primary">
                    <div class="text-center text-md-right mr-md-3 mb-4 mb-md-0">
                        <h3 class="mb-4">Dirección de nuestra planta</h3>
                        <h5 class="mb-3"><i class="fa fa-check text-success float-md-right mr-2 mr-md-0 ml-md-2"></i>Carretera Nacional Vieja Cagua-La Villa,<br>Galpón 105-0-05, Cagua, Edo. Aragua.</h5>
                        
                  </div>
                </div>
                <div class="col-md-6">
                    <div class="text-center text-md-left ml-md-3">
                        <h3 class="mb-4">Escríbenos a nuestro Whatsapp</h3>
                        <h5 class="mb-3"><i class="fa fa-check text-success mr-2"></i> 0424 309 15 87</h5>
                        <h3 class="mb-4">Escríbenos a nuestro correo</h3>
                        <h5 class="mb-3"><i class="fa fa-check text-success mr-2"></i>ventas@oxivea.com,
                        </h5>
                    </div>
                </div>
                <div class="col-md-12 text-center pt-3">
                    <a class="btn btn-primary font-weight-bold py-3 px-5 mt-4 btn-scroll" href="#contact">Comunícate con nosotros</a>
                </div>
            </div>
        </div>
    </div>
    <!-- FAQs End -->
        
        
    
    <div class="row" align="center">
        <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3927.3997630995677!2d-67.44793362915514!3d10.148123785990606!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x8e801f68acc5dc09%3A0xf76098fe0b1ad56e!2sOxivea%2C+C.A.!5e0!3m2!1ses-419!2sve!4v1534792845230" width="1920" height="500" frameborder="0" style="border:0" allowfullscreen></iframe>
        </div>
    <!-- Contact End -->


    <!-- Footer Start -->
    <div class="container-fluid bg-dark text-white py-5 px-sm-3 px-lg-5" style="margin-top: 90px;">
<div class="row pt-5">
            <div class="col-12 mb-4 px-4">
                <div class="row mb-5 p-4" style="background: rgba(256, 256, 256, .05);">
                    <div class="col-md-4">
                        <div class="text-md-center">
                            <h5 class="text-primary text-uppercase mb-2" style="letter-spacing: 5px;">Nuestra planta</h5>
                            <p class="mb-4 m-md-0">Carretera Nacional Vieja Cagua-La Villa, Galpón 105-0-05, Cagua, Edo. Aragua.</p>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="text-md-center">
                            <h5 class="text-primary text-uppercase mb-2" style="letter-spacing: 5px;">Escríbenos un email</h5>
                            <p class="mb-4 m-md-0"><a href="mailto:ventas@oxivea.com">ventas@oxivea.com</a></p>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="text-md-center">
                            <h5 class="text-primary text-uppercase mb-2" style="letter-spacing: 5px;">Llámanos</h5>
                            <p class="m-0">0424 - 309 1587</p>
                        </div>
                    </div>
                </div>
            </div>
  <div class="col-lg-12 col-md-12">
                <div class="row">
                    <div class="col-md-6 mb-6">
                        <p>Síguenos en nuestra cuenta de instagram <a href="http://instagram.com/oxivea_ca" target="_blank">OXIVEA_CA</a></p>
                        <div class="d-flex justify-content-start mt-4">
                            <a class="btn btn-lg btn-outline-light btn-lg-square" href="http://instagram.com/oxivea_ca" target="_blank"><i class="fab fa-instagram"></i></a>
                        </div>
                    </div>
                    <div class="col-md-6 mb-6">
                        <h5 class="text-primary text-uppercase mb-4" style="letter-spacing: 5px;">Nuestros equipo de trabajo </h5>
                        <p>Somos parte del <a href="http://somosteamiron.com" target="_blank">TEAM IRON</a></p>
                        <div class="d-flex flex-column justify-content-start">
                            <a class="text-white btn-scroll mb-2" href="http://ironcompanyrsa.com" target="_blank"><i class="fa fa-angle-right mr-2"></i>Iron Company RSA</a>
                            <a class="text-white btn-scroll" href="http://ironcompanytrading.com" target="_blank"><i class="fa fa-angle-right mr-2"></i>Iron Company Trading</a>
                            <a class="text-white btn-scroll mb-2" href="http://venplastic.com" target="_blank"><i class="fa fa-angle-right mr-2"></i>Ven Plastic</a>
                            <a class="text-white btn-scroll mb-2" href="http://transportevzla.com" target="_blank"><i class="fa fa-angle-right mr-2"></i>Transporte E Inversiones Venezuela</a>
                            <a class="text-white btn-scroll mb-2" href="http://fletesmar.com" target="_blank"><i class="fa fa-angle-right mr-2"></i>Fletes Mar</a>
                            
                        </div>
                  </div>
                </div>
    </div>
</div>
    <div class="container-fluid bg-dark text-white text-center border-top py-4 px-sm-3 px-md-5" style="border-color: rgba(256, 256, 256, .05) !important;">
        <p class="m-0 text-white">&copy; <a href="#">OXIVEA, C.A.</a>. All Rights Reserved. Designed by <a href="http://talentocriollo.com">Talento Criollo</a></p>
    </div>
    <!-- Footer End -->


    <!-- Modal -->
    <div class="modal fade" id="oxihierro" tabindex="-1" role="dialog" aria-labelledby="oxihierro"
        aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="oxiyeso">Oxihierro</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <img class="img-fluid mb-4" src="ficha/oxihierro.jpg" alt="">
                    <h1>OXIHIERRO</h1>
                    <p>Pigmentos naturales de óxido de hierro.</p>
                    
                    <h1>Uso y Características</h1>
                    <p>Área de pintura: 
Para elaborar colores minerales y matices de colores.<br>
Área de herrería:
Para elaborar fondo de herrerría como agente anticorrosivo.<br>
Área electrónica:
Para circuitos impresos como conductor.<br>

Además se usa en la industria automotriz en la fabricación de pastillas para frenos y como aditivo en la preparación de alimentos concentrados para animales.
</p>
                </div>
            </div>
        </div>
    </div>
    
    
    
    
    <div class="modal fade" id="venpego" tabindex="-1" role="dialog" aria-labelledby="venpego"
        aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">Venpego</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <img class="img-fluid mb-4" src="ficha/venpego.jpg" alt="">
                    <h1>VENPEGO</h1>
                    <p>Es un mortero en polvo de alto desempeño, a base de cemento blanco o gris, arena silice de granulometría controlada y aditivos químicos con excelente adherencia y de fácil manejo.</p>
                    
                    <h1>Uso y Características</h1>
                    <p>1.- Para aplicaciones donde se requiere una elevada adherencia y resistencia a las tensiones mecánicas, deslizamiento reducido y alto tiempo abierto.
2.- Para la colocación de cerámica en pisos y paredes.<br>
3.- Para la colocación de revestimientos cerámicos sobre superficies de madera.<br>
4.- Para la colocación de piezas de porcelanato de grandes formatos.<br>
5.- Indicado para ambientes sujetos a alta variación de temperatura, elevado tráfico y vibraciones.</p>
                </div>
            </div>
        </div>
    </div>
        
        
        <div class="modal fade" id="yeso" tabindex="-1" role="dialog" aria-labelledby="oxiconstruccion"
        aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">Oxiconstrucción</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <img class="img-fluid mb-4" src="ficha/yeso.jpg" alt="">
                    <h1>OXIYESO</h1>
                    <p>Es un YESO de fraguado medio, con tiempos abiertos y de plasticidad largos, que le dan una excelente manejabilidad y fácil instalación, permitiendo cubrir grandes áreas con una sola mezcla ahorrando tiempo de aplicación. Su máximo grado fino permite dejar la superficie tersa y lisa, sin necesidad de retocar por ralladuras. Su color BLANCO le da una apariencia superior. OXIYESO es muy seguro al usarse, ya que no es toxico, ni combustible y no requiere cuidados especiales para su preparación o manejo.</p>
                    
                    <h1>Uso y Características</h1>
                    <p>1.- Prepare la superficie sobre la que se aplicara el OXIYESO, si es block, ladrillo o mortero, humedezca la superficie y quite los excesos de material.<br>
2.- Colocar agua limpia en una bandeja en proporción al OXIYESO a usar.<br>
3.- Dependiendo del tiempo de fraguado que se busque, podrá batir el producto, por 1 minutos aprox. En este caso el tiempo a trabajar la mezcla será más corto, por lo que se recomienda preparar únicamente la cantidad que se vaya aplicar en ese tiempo.<br>
4.- Otro procedimiento, esperar que el OXIYESO se hidrate y adquiera una consistencia pastosa, y aplíquelo sobre la superficie a trabajar hasta adquirir el grosor deseado, el tiempo de esta mezcla será de 45 min. Aprox. (Deje fraguar el OXIYESO sobre las superficies).</p>
                </div>
            </div>
        </div>
    </div>
                        
                        
        
        
        <div class="modal fade" id="oxicolor" tabindex="-1" role="dialog" aria-labelledby="oxicolor"
        aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">Oxicolor</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <img class="img-fluid mb-4" src="ficha/oxicolor.jpg" alt="">
                    <h1>OXICOLOR</h1>
                    <p>Sellador para el relleno de juntas. (Carateo)</p>
                    
                    <h1>Uso y Características</h1>
                    <p>Sellador de juntas entre baldosa de pavimentos y revestimientos, tanto en INTERIORES como EXTERIORES.<BR>
Relleno de juntas entre azulejos, mosaicos, cerámica, gres extrusionado.<br>
Relleno de juntas entre ladrillos, piedras naturales, mármoles, baldosas hidráulicas, terracotas</p>
                </div>
            </div>
        </div>
    </div>
        
        
        
        <div class="modal fade" id="oxiconstruccion" tabindex="-1" role="dialog" aria-labelledby="oxiconstruccion"
        aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">Oxiconstrucción</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <img class="img-fluid mb-4" src="ficha/oxiconstruccion.jpg" alt="">
                    <h1>OXICONSTRUCCIÓN</h1>
                    <p>Oxiconstrucción Multicreto es un mortero seco a base de cemento, arena sílice de granulometría seleccionada y aditivos que garantizan adherencia, cohesión, resistencia y mejores acabados que las mezclas tradicionales, con solo agregar agua, sirve para pegar bloques de arcilla y concreto, ladrillos, piedras, tejas, friso de paredes, también se puede utilizar para fabricar elementos estructurales: Cimientos, Columnas, Pisos, Vigas, y Placas. (Agregar piedra de ser necesario).</p>
                    
                    <h1>Uso y Características</h1>
                    <p>1.- Limpiar la zona a trabajar con OXICONSTRUCCIÓN MULTICRETO, para que esté libre de polvo, aceites, grasas, cera, pinturas, eflorescencia y cualquier otro factor contaminante.<BR>
2.- Antes de aplicar OXICONSTRUCCIÓN MULTICRETO, debe tomarse en cuenta la superficie sea sólida, resistente y cohesivo, con una temperatura menor a 30°C.<BR>
3.- Agregar agua limpia al OXICONSTRUCCIÓN MULTICRETO, seguidamente de la piedra según su uso, mézclelo por 5 minutos hasta que su consistencia sea homogénea.<BR>
4.- Aplique y compacte toda la mezcla en la superficie a trabajar.<BR>
5.- Aplique agua por al menos 7 días para obtener un curado apropiado ya que requiere el mismo proceso del concreto convencional.<BR>
6.- La mezcla para friso no lleva piedra.</p>
                </div>
            </div>
        </div>
    </div>
                        
                        
                        
                        <div class="modal fade" id="supercreto" tabindex="-1" role="dialog" aria-labelledby="supercreto"
        aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">Supercreto</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <img class="img-fluid mb-4" src="ficha/supercreto.jpg" alt="">
                    <h1>SUPERCRETO</h1>
                    <p>Mezcla para utilizar igual que el cemento.</p>
                    
                    <h1>Uso y Características</h1>
                    <p>Se usa de la misma forma que el cemento.</p>
                </div>
            </div>
        </div>
    </div>
                    
                    
                    <div class="modal fade" id="oxicolorcaucho" tabindex="-1" role="dialog" aria-labelledby="oxicolorcaucho"
        aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">Oxicolorcaucho</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <img class="img-fluid mb-4" src="ficha/oxicolorcaucho.jpg" alt="">
                    <h1>OXICOLOR CAUCHO</h1>
                    <p>Nueva línea de pinturas.</p>
                    
                    
                </div>
            </div>
        </div>
    </div>
                        
                        
                        
        
    <!-- Modal -->


    <!-- Scroll to Bottom -->
    <i class="fa fa-2x fa-angle-down text-white scroll-to-bottom"></i>

    <!-- Back to Top -->
    <a href="#" class="btn btn-lg btn-outline-primary btn-lg-square back-to-top"><i class="fa fa-angle-double-up"></i></a>


    <!-- JavaScript Libraries -->
    <script src="http://code.jquery.com/jquery-3.4.1.min.js"></script>
    <script src="http://stackpath.bootstrapcdn.com/bootstrap/4.4.1/js/bootstrap.bundle.min.js"></script>
    <script src="lib/easing/easing.min.js"></script>
    <script src="lib/waypoints/waypoints.min.js"></script>
    <script src="lib/owlcarousel/owl.carousel.min.js"></script>
    <script src="lib/isotope/isotope.pkgd.min.js"></script>
    <script src="lib/lightbox/js/lightbox.min.js"></script>

    <!-- Contact Javascript File -->
    <script src="mail/jqBootstrapValidation.min.js"></script>
    <script src="mail/contact.js"></script>

    <!-- Template Javascript -->
    <script src="js/main.js"></script>
                </div>
</body>

</html>