<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="utf-8">
    <title>OXIYESO: Yeso de Construcción de Fraguado Medio y Alta Plasticidad</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
   <meta name="description" content="OXIYESO es un yeso de construcción de fraguado medio, alta plasticidad y excelente acabado. Ideal para cubrir grandes áreas con facilidad y rapidez.">
    <meta name="keywords" content="oxiyeso, yeso de construcción, yeso blanco, yeso de fraguado medio, yeso para paredes, oxivea">
    <meta name="author" content="Oxivea">

    <meta property="og:title" content="OXIYESO: Yeso de Construcción Profesional">
    <meta property="og:description" content="Yeso blanco de fraguado medio con excelente manejabilidad, acabado liso y alto rendimiento para obras profesionales.">
    <meta property="og:image" content="logo.jpg">
    <meta property="og:url" content="https://oxivea.com/blog/oxiyeso">
    <meta property="og:type" content="article">

    <link rel="canonical" href="https://oxivea.com/blog/oxiyeso-yeso-construccion">

    <link href="logo.jpg" rel="icon" type="image/x-icon">

    <link rel="preconnect" href="https://fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat&family=Roboto:wght@500;700&display=swap" rel="stylesheet"> 

    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css" rel="stylesheet">
    <link href="lib/owlcarousel/assets/owl.carousel.min.css" rel="stylesheet">
    <link href="lib/lightbox/css/lightbox.min.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">
    
  <!-- Schema.org -->
    <script type="application/ld+json">
    {
      "@context": "https://schema.org",
      "@type": "BlogPosting",
      "headline": "OXIYESO: Yeso de Construcción de Fraguado Medio",
      "image": ["https://oxivea.com/img/oxiyeso.jpg"],
      "datePublished": "2024-01-15T08:00:00+00:00",
      "author": {
        "@type": "Organization",
        "name": "Oxivea",
        "url": "https://oxivea.com"
      },
      "publisher": {
        "@type": "Organization",
        "name": "Oxivea",
        "logo": {
          "@type": "ImageObject",
          "url": "https://oxivea.com/img/logo.png"
        }
      },
      "description": "Yeso blanco de fraguado medio, alta plasticidad y excelente acabado para construcción.",
      "keywords": "oxiyeso, yeso de construccion, yeso blanco, yeso oxivea"
    }
    </script>
    
    <style type="text/css">
    body,td,th {
        font-family: Montserrat, sans-serif;
        line-height: 1.6;
    }
    
    .blog-content img {
        max-width: 100%;
        height: auto;
        margin: 20px 0;
        border-radius: 5px;
    }
    
    .blog-meta {
        color: #6c757d;
        font-size: 0.9rem;
    }
    
    .blog-meta i {
        color: #007bff;
        margin-right: 5px;
    }
    
    .blog-tags {
        margin-top: 30px;
    }
    
    .blog-tags .badge {
        background-color: #f8f9fa;
        color: #007bff;
        border: 1px solid #dee2e6;
        margin-right: 5px;
        padding: 5px 10px;
        font-weight: normal;
        font-size: 0.85rem;
    }
    
    .blog-author {
        background-color: #f8f9fa;
        border-radius: 5px;
        padding: 20px;
        margin-top: 40px;
    }
    
    .related-posts {
        margin-top: 50px;
    }
    
    .related-post-item {
        transition: all 0.3s ease;
        border: 1px solid #dee2e6;
        border-radius: 5px;
        overflow: hidden;
        height: 100%;
    }
    
    .related-post-item:hover {
        transform: translateY(-5px);
        box-shadow: 0 5px 15px rgba(0,0,0,0.1);
    }
    
    .related-post-item img {
        width: 100%;
        height: 200px;
        object-fit: cover;
    }
    
    /* Ajuste específico para el header de la página */
    .page-header {
        margin-top: 0;
        padding-top: 100px;
        padding-bottom: 100px;
    }
    
    /* Breadcrumb mejorado */
    .breadcrumb-nav {
        background: transparent;
        padding: 0;
    }
    
    .breadcrumb-nav a {
        color: rgba(255,255,255,0.9);
        text-decoration: none;
        transition: color 0.3s;
    }
    
    .breadcrumb-nav a:hover {
        color: #007bff;
        text-decoration: underline;
    }
    
    /* Mejoras para tarjetas de productos */
    .product-card {
        border: none;
        border-radius: 8px;
        overflow: hidden;
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        height: 100%;
    }
    
    .product-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 20px rgba(0,0,0,0.1);
    }
    
    .product-card .card-body {
        padding: 1.5rem;
    }
    
    /* Beneficios iconos */
    .benefit-icon {
        transition: transform 0.3s ease;
    }
    
    .benefit-icon:hover {
        transform: scale(1.1);
    }
    
    /* Mejoras de accesibilidad */
    .sr-only {
        position: absolute;
        width: 1px;
        height: 1px;
        padding: 0;
        margin: -1px;
        overflow: hidden;
        clip: rect(0,0,0,0);
        white-space: nowrap;
        border: 0;
    }
    
    /* Ajustes específicos para móviles */
    @media (max-width: 768px) {
        body {
            padding-top: 0px;
            font-size: 16px;
        }
        
        .page-header {
            padding-top: 70px;
            padding-bottom: 70px;
            background-position: center center;
        }
        
        .page-header h1 {
            font-size: 1.8rem;
            margin-bottom: 1rem;
        }
        
        .blog-content h1 {
            font-size: 1.6rem;
            line-height: 1.3;
            margin-bottom: 1rem;
        }
        
        .blog-content h2 {
            font-size: 1.4rem;
        }
        
        .blog-content h3 {
            font-size: 1.3rem;
            margin-top: 1.5rem;
            margin-bottom: 0.8rem;
        }
        
        .blog-content h4 {
            font-size: 1.2rem;
        }
        
        .blog-content p {
            font-size: 1rem;
            margin-bottom: 1rem;
        }
        
        .blog-content img {
            margin: 15px 0;
        }
        
        .breadcrumb-nav {
            font-size: 0.85rem;
        }
        
        .product-card {
            margin-bottom: 1rem;
        }
        
        .row.text-center .col-md-3 {
            width: 50%;
            float: left;
            padding: 0 5px;
            margin-bottom: 10px;
        }
        
        .benefit-icon {
            font-size: 1.5rem;
            margin-bottom: 0.5rem;
        }
        
        .related-posts {
            margin-top: 30px;
        }
        
        .related-posts h3 {
            font-size: 1.5rem;
            margin-bottom: 1.5rem;
        }
        
        .related-post-item {
            margin-bottom: 1.5rem;
        }
        
        .related-post-item h5 {
            font-size: 1rem;
        }
        
        .related-post-item p {
            font-size: 0.85rem;
        }
        
        /* Footer responsive */
        .footer-info .col-md-4 {
            margin-bottom: 2rem;
            text-align: center;
        }
        
        .footer-info .text-md-center {
            text-align: center !important;
        }
        
        .footer-links {
            text-align: center;
        }
        
        .footer-links a {
            display: block;
            margin-bottom: 0.5rem;
        }
        
        .social-icons {
            justify-content: center;
            margin-top: 1rem;
        }
        
        .navbar-brand h1 {
            font-size: 1.4rem;
        }
        
        .navbar-nav .nav-item {
            text-align: center;
        }
    }
    
    @media (max-width: 576px) {
        .page-header {
            padding-top: 60px;
            padding-bottom: 60px;
        }
        
        .page-header h1 {
            font-size: 1.5rem;
        }
        
        .blog-content h1 {
            font-size: 1.4rem;
        }
        
        .row.text-center .col-md-3 {
            width: 100%;
            float: none;
            margin-bottom: 15px;
        }
        
        .navbar-brand h1 {
            font-size: 1.2rem;
        }
        
        .container-fluid {
            padding-left: 15px;
            padding-right: 15px;
        }
        
        .related-post-item img {
            height: 180px;
        }
        
        /* Ajustes de padding para móviles pequeños */
        .container.py-5 {
            padding-top: 2rem !important;
            padding-bottom: 2rem !important;
        }
        
        .p-3, .p-4, .p-5 {
            padding: 1rem !important;
        }
        
        .mb-4, .mb-5 {
            margin-bottom: 1.5rem !important;
        }
        
        .mt-4, .mt-5 {
            margin-top: 1.5rem !important;
        }
    }
    
    @media (max-width: 360px) {
        .page-header h1 {
            font-size: 1.3rem;
        }
        
        .blog-content h1 {
            font-size: 1.2rem;
        }
        
        .navbar-brand h1 {
            font-size: 1rem;
        }
        
        .btn-lg {
            padding: 0.5rem 1rem;
            font-size: 0.9rem;
        }
    }
    
    /* Mejoras de impresión */
    @media print {
        .navbar, .footer, .back-to-top, .scroll-to-bottom {
            display: none !important;
        }
        
        .page-header {
            padding: 20px 0 !important;
            background: none !important;
            color: #000 !important;
        }
        
        a {
            color: #000 !important;
            text-decoration: none !important;
        }
        
        .blog-content {
            font-size: 12pt;
        }
    }
    </style>
</head>

<body data-spy="scroll" data-target=".navbar" data-offset="51">
    <!-- Navbar Start - Siempre visible -->
    <nav class="navbar fixed-top shadow-sm navbar-expand-lg bg-dark navbar-dark py-1 py-lg-0 px-lg-5">
        <a href="index.html" class="navbar-brand d-block d-lg-none">
        <h4 class="h4 text-white text-uppercase m-0">OXIVEA</h4>
        </a>
        <button type="button" class="navbar-toggler" data-toggle="collapse" data-target="#navbarCollapse"
                aria-label="Menú de navegación" aria-expanded="false" aria-controls="navbarCollapse">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse justify-content-between" id="navbarCollapse">
            <div class="navbar-nav ml-auto py-0">
                <a href="index.html" class="nav-item nav-link">Inicio</a>
                <a href="index.html#service" class="nav-item nav-link">Ficha Técnica</a>
            </div>
            <a href="index.html" class="navbar-brand bg-primary px-4 mx-3 d-none d-lg-block" aria-label="Oxivea - Inicio">
             <h4 class="display-4 text-white text-uppercase m-0">OXIVEA</h4>
            </a>
            <div class="navbar-nav mr-auto py-0">
                <a href="index.html#project" class="nav-item nav-link">Productos</a>
                <a href="index.html#contact" class="nav-item nav-link">Contacto</a>
                <a href="blog.html" class="nav-item nav-link active">Blog</a>
            </div>
        </div>
    </nav>
    <!-- Navbar End -->

    <!-- Page Header Start -->
    <div class="container-fluid page-header" style="background: linear-gradient(rgba(0, 0, 0, 0.7), rgba(0, 0, 0, 0.7)), url('img/carousel-2.jpg') center center no-repeat; background-size: cover;">
        <div class="container py-5">
            <div class="row">
                <div class="col-12 text-center">
                    <h1 class="display-4 text-white font-secondary mb-3">OXIYESO: Yeso de Construcción de Fraguado Medio y Alta Plasticidad</h1>
                    
                </div>
            </div>
        </div>
    </div>
    <!-- Page Header End -->

    <!-- Blog Content Start -->
    <div class="container-fluid py-5">
        <div class="container py-5">
            <div class="row">
              

<!-- CONTENIDO DEL BLOG -->
<div class="container py-5">
    <article class="blog-content">

      
<figure align="center">
<img src="oxiyeso.jpg" alt="OXIYESO yeso de construcción Oxivea" class="img-fluid rounded">
</figure>

<p class="lead mt-4">
<strong>OXIYESO de Oxivea</strong> es un <strong>yeso de construcción de fraguado medio</strong>, desarrollado para ofrecer <strong>alta plasticidad, excelente manejabilidad y un acabado blanco liso y uniforme</strong>. Su formulación permite trabajar grandes superficies con una sola mezcla, optimizando tiempo y rendimiento en obra.
</p>

<section class="mt-5">
<h2>¿Qué es OXIYESO y para qué se utiliza?</h2>
<p>
OXIYESO es un <strong>yeso fino de uso profesional</strong>, ideal para <strong>revestir, alisar y nivelar superficies interiores</strong> como paredes y techos de block, ladrillo o mortero.
</p>
<p>
Gracias a su <strong>tiempo abierto prolongado</strong> y fraguado controlado, permite un trabajo cómodo, preciso y sin desperdicios, logrando superficies <strong>tersas, lisas y listas para pintar</strong>.
</p>
</section>

<section class="mt-5">
<h2>Ventajas del yeso OXIYESO</h2>
<ul>
<li>Fraguado medio con mayor tiempo de trabajo</li>
<li>Alta plasticidad y fácil aplicación</li>
<li>Excelente acabado blanco y liso</li>
<li>No requiere retoques por ralladuras</li>
<li>Alto rendimiento por metro cuadrado</li>
<li>No tóxico, no combustible y seguro de usar</li>
</ul>
</section>

<section class="mt-5">
<h2>Usos recomendados</h2>
<ul>
<li>Revestimiento de paredes interiores</li>
<li>Alisado de superficies de block y ladrillo</li>
<li>Corrección de imperfecciones en muros</li>
<li>Trabajos de remodelación y acabados finos</li>
<li>Obras residenciales y comerciales</li>
</ul>
</section>

<section class="mt-5">
<h2>Ficha técnica de OXIYESO</h2>

<table class="table table-bordered">
<tr>
<th>Color</th>
<td>Blanco</td>
</tr>
<tr>
<th>Granulometría (Malla N°100)</th>
<td>93,56%</td>
</tr>
<tr>
<th>Dosis</th>
<td>5 a 6 litros de agua</td>
</tr>
<tr>
<th>Tiempo abierto</th>
<td>45 minutos aprox.</td>
</tr>
<tr>
<th>Rendimiento (1 cm de espesor)</th>
<td>8,5 kg/m²</td>
</tr>
<tr>
<th>Resistencia a la compresión (en seco)</th>
<td>8,5 kg/m²</td>
</tr>
<tr>
<th>Presentación</th>
<td>Saco de 5 kg</td>
</tr>
</table>
</section>

<section class="mt-5">
<h2>Preparación de la superficie</h2>
<p>
La superficie debe estar <strong>limpia, firme y libre de polvo o material suelto</strong>.  
En superficies de block, ladrillo o mortero, se recomienda <strong>humedecer previamente</strong> para evitar una absorción excesiva del agua de la mezcla.
</p>
</section>

<section class="mt-5">
<h2>Modo de empleo de OXIYESO</h2>
<ol>
<li>Colocar agua limpia en una bandeja.</li>
<li>Agregar OXIYESO en proporción de 5 a 6 litros por saco.</li>
<li>Batir durante 1 minuto aproximadamente.</li>
<li>Dejar hidratar hasta obtener consistencia pastosa.</li>
<li>Aplicar sobre la superficie hasta lograr el espesor deseado.</li>
</ol>
<p>
El tiempo de trabajo aproximado de la mezcla es de <strong>45 minutos</strong>.
</p>
</section>


<figure align="center">
<img src="oxiyeso.png" alt="OXIYESO yeso de construcción Oxivea" class="img-fluid rounded">
</figure>

<section class="mt-5 alert alert-primary">
<h3>¿Buscas un yeso confiable y de excelente acabado?</h3>
<p>
<strong>OXIYESO de Oxivea</strong> es la mejor elección para profesionales que necesitan <strong>calidad, rendimiento y facilidad de aplicación</strong> en cada proyecto.
</p>
<a href="index.html#contact" class="btn btn-primary">Solicitar cotización</a>
</section>

  
      

    </article>
</div>


              <!-- Related Posts -->
            <section class="related-posts" aria-labelledby="related-posts-heading">
                <h3 id="related-posts-heading" class="font-secondary display-5 mb-4">Artículos Relacionados</h3>
                
                  <!-- Service Start -->
    <div class="container-fluid py-5" id="service">
        <div class="container py-5">          
            <div class="row">
                <div class="col-lg-4 mb-3">
                    <div class="product-item mb-2">
                        <div class="product-img">
                            <img class="img-fluid" src="img/product-1.jpg" alt="">
                            <a type="button" href="venpego" class="btn btn-primary"  data-target="#venpego">
                                <i class="fa fa-2x fa-plus text-white"></i>
                            </a>
                          
                        </div>
                        <div class="bg-secondary text-center p-4">
                       <h3 class="m-0"><a href="venpego">Venpego</a></h3>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 mb-3">
                    <div class="product-item mb-2">
                        <div class="product-img">
                            <img class="img-fluid" src="img/product-2.jpg" alt="">
                            <a type="button"  href="oxicolor" class="btn btn-primary"  data-target="#oxicolor">
                                <i class="fa fa-2x fa-plus text-white"></i>
                            </a>
                        </div>
                        <div class="bg-secondary text-center p-4">
                            <h3 class="m-0"><a href="oxicolor">Oxicolor</a></h3>

                        </div>
                    </div>
                </div>
                <div class="col-lg-4 mb-3">
                    <div class="product-item mb-2">
                        <div class="product-img">
                            <img class="img-fluid" src="img/product-3.jpg" alt="">
                            <a type="button" href="oxihierro" class="btn btn-primary"  data-target="#oxihierro">
                                <i class="fa fa-2x fa-plus text-white"></i>
                            </a>
                        </div>
                        <div class="bg-secondary text-center p-4">
                            <h3 class="m-0"><a href="oxihierro">Oxihierro</a></h3>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 mb-3">
                    <div class="product-item mb-2">
                        <div class="product-img">
                            <img class="img-fluid" src="img/product-4.jpg" alt="">
                            <a type="button" class="btn btn-primary" href="oxiconstruccion" data-target="#oxiconstruccion">
                                <i class="fa fa-2x fa-plus text-white"></i>
                            </a>
                        </div>
                        <div class="bg-secondary text-center p-4">
                            <h3 class="m-0"><a href="oxiconstruccion">Oxiconstrucción</a></h3>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 mb-3">
                    <div class="product-item mb-2">
                        <div class="product-img">
                            <img class="img-fluid" src="img/product-5.jpg" alt="">
                            <a type="button" class="btn btn-primary" href="oxiyeso" data-target="#yeso">
                                <i class="fa fa-2x fa-plus text-white"></i>
                            </a>
                        </div>
                        <div class="bg-secondary text-center p-4">
                            <h3 class="m-0"><a href="oxiyeso">Oxiyeso</a></h3>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 mb-3">
                    <div class="product-item mb-2">
                        <div class="product-img">
                            <img class="img-fluid" src="img/product-6.jpg" alt="">
                            <a type="button" class="btn btn-primary" href="superconcreto" data-target="#supercreto">
                                <i class="fa fa-2x fa-plus text-white"></i>
                            </a>
                        </div>
                        <div class="bg-secondary text-center p-4">
                            <h3 class="m-0"><a href="superconcreto">Supercreto</a></h3>
                        </div>
                  </div>
                </div>
                <div class="col-lg-4 mb-3">
                    <div class="product-item mb-2">
                        <div class="product-img">
                            <img class="img-fluid" src="img/product-7.jpg" alt="">
                            <a type="button" class="btn btn-primary" href="oxicaucho" data-target="#oxicolorcaucho">
                                <i class="fa fa-2x fa-plus text-white"></i>
                            </a>
                        </div>
                        <div class="bg-secondary text-center p-4">
                            <h3 class="m-0"><a href="oxicaucho">Oxicolor Caucho</a></h3>
                        </div>
                  </div>
                </div>
            </div>
        </div>
    </div>
            </section>
        </div>
    </div>
    <!-- Blog Content End -->

    <!-- Footer Start -->
    <footer class="container-fluid bg-dark text-white py-5 px-sm-3 px-lg-5" style="margin-top: 90px;">
        <div class="row pt-5">
            <div class="col-12 mb-4 px-4">
                <div class="row mb-5 p-4" style="background: rgba(256, 256, 256, .05);">
                    <div class="col-md-4 footer-info">
                        <div class="text-md-center">
                            <h5 class="text-primary text-uppercase mb-2" style="letter-spacing: 5px;">Nuestra planta</h5>
                            <address class="mb-4 m-md-0">Carretera Nacional Vieja Cagua-La Villa, Galpón 105-0-05, Cagua, Edo. Aragua.</address>
                        </div>
                    </div>
                    <div class="col-md-4 footer-info">
                        <div class="text-md-center">
                            <h5 class="text-primary text-uppercase mb-2" style="letter-spacing: 5px;">Escríbenos un email</h5>
                            <p class="mb-4 m-md-0"><a href="mailto:ventas@oxivea.com" class="text-white">ventas@oxivea.com</a></p>
                        </div>
                    </div>
                    <div class="col-md-4 footer-info">
                        <div class="text-md-center">
                            <h5 class="text-primary text-uppercase mb-2" style="letter-spacing: 5px;">Llámanos</h5>
                            <p class="m-0">0424 - 309 1587</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-12 col-md-12">
                <div class="row">
                    <div class="col-md-6 mb-5">
                        <p>Síguenos en nuestra cuenta de instagram <a href="http://instagram.com/oxivea_ca" target="_blank" class="text-white" rel="noopener noreferrer">OXIVEA_CA</a></p>
                        <div class="d-flex justify-content-start mt-4 social-icons">
                            <a class="btn btn-lg btn-outline-light btn-lg-square" href="http://instagram.com/oxivea_ca" target="_blank" aria-label="Instagram de Oxivea" rel="noopener noreferrer"><i class="fab fa-instagram"></i></a>
                        </div>
                    </div>
                    <div class="col-md-6 mb-5">
                        <h5 class="text-primary text-uppercase mb-4" style="letter-spacing: 5px;">Nuestro equipo de trabajo</h5>
                        <p>Somos parte del <a href="http://somosteamiron.com" target="_blank" class="text-white" rel="noopener noreferrer">TEAM IRON</a></p>
                        <div class="d-flex flex-column justify-content-start footer-links">
                            <a class="text-white btn-scroll mb-2" href="http://ironcompanyrsa.com" target="_blank" rel="noopener noreferrer"><i class="fa fa-angle-right mr-2"></i>Iron Company RSA</a>
                            <a class="text-white btn-scroll mb-2" href="http://ironcompanytrading.com" target="_blank" rel="noopener noreferrer"><i class="fa fa-angle-right mr-2"></i>Iron Company Trading</a>
                            <a class="text-white btn-scroll mb-2" href="http://venplastic.com" target="_blank" rel="noopener noreferrer"><i class="fa fa-angle-right mr-2"></i>Ven Plastic</a>
                            <a class="text-white btn-scroll mb-2" href="http://transportevzla.com" target="_blank" rel="noopener noreferrer"><i class="fa fa-angle-right mr-2"></i>Transporte E Inversiones Venezuela</a>
                            <a class="text-white btn-scroll mb-2" href="http://fletesmar.com" target="_blank" rel="noopener noreferrer"><i class="fa fa-angle-right mr-2"></i>Fletes Mar</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </footer>
    <div class="container-fluid bg-dark text-white text-center border-top py-4 px-sm-3 px-md-5" style="border-color: rgba(256, 256, 256, .05) !important;">
        <p class="m-0 text-white">&copy; <a href="index.html" class="text-white">OXIVEA, C.A.</a>. Todos los derechos reservados. Diseñado por <a href="http://talentocriollo.com" target="_blank" class="text-white" rel="noopener noreferrer">Talento Criollo</a></p>
    </div>
    <!-- Footer End -->

    <!-- Scroll to Bottom -->
    <i class="fa fa-2x fa-angle-down text-white scroll-to-bottom d-none d-md-block" aria-hidden="true"></i>

    <!-- Back to Top -->
    <a href="#" class="btn btn-lg btn-outline-primary btn-lg-square back-to-top" aria-label="Volver arriba"><i class="fa fa-angle-double-up"></i></a>

    <!-- JavaScript Libraries -->
    <script src="http://code.jquery.com/jquery-3.4.1.min.js" defer></script>
    <script src="http://stackpath.bootstrapcdn.com/bootstrap/4.4.1/js/bootstrap.bundle.min.js" defer></script>
    <script src="lib/easing/easing.min.js" defer></script>
    <script src="lib/waypoints/waypoints.min.js" defer></script>
    
    <!-- Carga condicional de scripts -->
    <script>
    document.addEventListener("DOMContentLoaded", function() {
        // Cargar scripts de carrusel solo si es necesario
        if (document.querySelector('.owl-carousel')) {
            var owlScript = document.createElement('script');
            owlScript.src = 'lib/owlcarousel/owl.carousel.min.js';
            owlScript.defer = true;
            document.body.appendChild(owlScript);
        }
        
        // Cargar lightbox solo si hay imágenes con data-lightbox
        if (document.querySelector('[data-lightbox]')) {
            var lightboxScript = document.createElement('script');
            lightboxScript.src = 'lib/lightbox/js/lightbox.min.js';
            lightboxScript.defer = true;
            document.body.appendChild(lightboxScript);
        }
        
        // Cargar isotope solo si hay filtros
        if (document.querySelector('.isotope')) {
            var isotopeScript = document.createElement('script');
            isotopeScript.src = 'lib/isotope/isotope.pkgd.min.js';
            isotopeScript.defer = true;
            document.body.appendChild(isotopeScript);
        }
        
        // Script para back to top
        var backToTop = document.querySelector('.back-to-top');
        if (backToTop) {
            window.addEventListener('scroll', function() {
                if (window.pageYOffset > 300) {
                    backToTop.style.display = 'block';
                } else {
                    backToTop.style.display = 'none';
                }
            });
            
            backToTop.addEventListener('click', function(e) {
                e.preventDefault();
                window.scrollTo({top: 0, behavior: 'smooth'});
            });
        }
    });
    </script>

    <!-- Template Javascript -->
    <script src="js/main.js" defer></script>
</body>

</html>